<?php
namespace App\Controllers\partner;
use App\Controllers\BaseController;
use App\Models\Partners_model;
use App\Models\Service_model;
use App\Models\Service_ratings_model;
class Partner extends BaseController
{
    public function __construct()
    {
        helper('function', 'form', 'url', 'filesystem');
        $this->validation = \Config\Services::validation();
        $this->ionAuth = new \IonAuth\Libraries\IonAuth();
        $user = $this->ionAuth->user()->row();
        $this->data['admin'] = $this->userIsAdmin;
        $this->data['partner'] = $this->userIsPartner;
        $this->data['partnerId'] = $user->id;
        $this->data['Identity'] = $this->userIdentity;
        $this->data['settings'] = $this->settings;
        $this->partner = new Partners_model();
        $session = session();
        $lang = $session->get('lang');
        if (empty($lang)) {
            $lang = 'en';
        }
        $this->data['current_lang'] = $lang;
        $this->data['username'] =  $user->username;
        $this->data['languages_locale'] = fetch_details('languages', [], [], null, '0', 'id', 'ASC');
        $profile = '';
        if (!empty($data)) {
            $data = $data[0];
            if ($data['image'] != '') {
                if (check_exists(base_url($data['image']))) {
                    $profile = '<img alt="image" src="' .  base_url($data['image']) . '" class="rounded-circle mr-1">';
                } else {
                    $profile = '<figure class="avatar mb-2 avatar-sm mt-1" data-initial="' . strtoupper($data['username'][0]) . '"></figure>';
                }
            } else {
                $profile = '<figure class="avatar mb-2 avatar-sm mt-1" data-initial="' . strtoupper($data['username'][0]) . '"></figure>';
            }
            $this->data['profile_picture'] = $profile;
        }
        $this->data['profile_picture'] = $profile;
    }
    public function review()
    {
        $this->data['title'] = 'Reviews | Partner Panel';
        $this->data['main_page'] = 'reviews';
        return view('backend/partner/template', $this->data);
    }
    public function review_list()
    {
        $db      = \Config\Database::connect();
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
        $ratings = new Service_ratings_model();
        $data = $ratings->ratings_list(true, $search, $limit, $offset, $sort, $order, ['s.user_id' => $this->userId]);
        $bulkData = array();
        $rows = array();
        $tempRow = array();
        foreach ($data['data'] as $row) {
            $tempRow['id'] = $row['id'];
            $tempRow['user_name'] = $row['user_name'];
            $tempRow['profile_image'] = (!empty($row['profile_image']) && isset($row['profile_image'])) ? $row['profile_image'] : '';
            $tempRow['service_name'] = $row['service_name'];
            $tempRow['rating'] = $row['rating'];
            $tempRow['comment'] = $row['comment'];
            $tempRow['rated_on'] = $row['rated_on'];
            $tempRow['images'] = $row['images'];
            $rating_data = $db->table('services s')
                ->select('
                count(sr.rating) as number_of_rating, 
                SUM(sr.rating) as total_rating,
                (SUM(sr.rating) / count(sr.rating)) as average_rating
                ')
                ->join('services_ratings sr', 'sr.service_id = s.id')
                ->where('s.user_id', $row['partner_id'])
                ->get()->getResultArray();
            $tempRow['ratings'] = $row['rating'];
            if ($row['rating'] == 5) {
                $tempRow['stars'] = '
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>';
            } else if ($row['rating'] == 4) {
                $tempRow['stars'] = '
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star"></i>';
            } else if ($row['rating'] == 3) {
                $tempRow['stars'] = '
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star "></i>
                <i class="fa-solid fa-star "></i>';
            } else if ($row['rating'] == 2) {
                $tempRow['stars'] = '
                <i class="fa-solid fa-star text-primary"></i>
                <i class="fa-solid fa-star text-primary"></i>
                  <i class="fa-solid fa-star "></i>
                <i class="fa-solid fa-star "></i>
                <i class="fa-solid fa-star "></i>';
            } else if ($row['rating'] == 1) {
                $tempRow['stars'] = '
                <i class="fa-solid fa-star text-primary"></i>
                  <i class="fa-solid fa-star "></i>
                <i class="fa-solid fa-star "></i>
                <i class="fa-solid fa-star"></i>
                <i class="fa-solid fa-star"></i>';
            }
            $rate_data = get_ratings($row['partner_id']);
            $tempRow['1_star'] = $rate_data[0]['rating_1'];
            $tempRow['2_star'] = $rate_data[0]['rating_2'];
            $tempRow['3_star'] = $rate_data[0]['rating_3'];
            $tempRow['4_star'] = $rate_data[0]['rating_4'];
            $tempRow['5_star'] = $rate_data[0]['rating_5'];
            // print_r($tempRow);
            $rows[] = $tempRow;
        }
        $bulkData['rows'] = $rows;
        // print_r($bulkData);
        return json_encode($bulkData);
    }
}
